<?php
/**
 * Uninstall script for BrightTally plugin
 *
 * @package Bright_Tally
 * @since 1.0.0
 */

// If uninstall not called from WordPress, then exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Remove plugin options
delete_option('bright_tally_api_key');
delete_option('bright_tally_api_url');
delete_option('bright_tally_default_theme');
delete_option('bright_tally_cache_duration');
delete_option('bright_tally_docs_url');

// Remove OAuth tokens and user data
delete_option('bright_tally_access_token');
delete_option('bright_tally_token_expires_at');
delete_option('bright_tally_user_data');
delete_option('bright_tally_connection_status');
delete_option('bright_tally_onboarding_completed');
delete_option('bright_tally_oauth_state');

// Remove database tables
global $wpdb;

$table_name = $wpdb->prefix . 'bright_tally_polls';
// Sanitize table name to prevent SQL injection
$table_name = preg_replace('/[^a-zA-Z0-9_]/', '', $table_name);
$wpdb->query("DROP TABLE IF EXISTS `{$table_name}`");

// Clear any scheduled events
wp_clear_scheduled_hook('bright_tally_sync_polls');

// Remove any transients
delete_transient('bright_tally_polls_cache');
delete_transient('bright_tally_api_connection_test');
delete_transient('bright_tally_activation_redirect');
