<?php
/**
 * The public-facing functionality of the plugin
 *
 * @package Bright_Tally
 * @since 1.0.0
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

class Bright_Tally_Public {
    
    /**
     * The ID of this plugin
     *
     * @since 1.0.0
     * @var string
     */
    private $plugin_name;
    
    /**
     * The version of this plugin
     *
     * @since 1.0.0
     * @var string
     */
    private $version;
    
    /**
     * Initialize the class and set its properties
     *
     * @since 1.0.0
     * @param string $plugin_name The name of this plugin
     * @param string $version The version of this plugin
     */
    public function __construct($plugin_name, $version) {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }
    
    /**
     * Register the stylesheets for the public-facing side of the site
     *
     * @since 1.0.0
     */
    public function enqueue_styles() {
        wp_enqueue_style(
            $this->plugin_name,
            BRIGHT_TALLY_PLUGIN_URL . 'assets/css/public.css',
            array(),
            $this->version,
            'all'
        );
    }
    
    /**
     * Register the JavaScript for the public-facing side of the site
     *
     * @since 1.0.0
     */
    public function enqueue_scripts() {
        wp_enqueue_script(
            $this->plugin_name,
            BRIGHT_TALLY_PLUGIN_URL . 'assets/js/public.js',
            array('jquery'),
            $this->version,
            false
        );
        
        // Localize script for AJAX
        wp_localize_script($this->plugin_name, 'bright_tally_public_ajax', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('bright_tally_public_nonce')
        ));
    }
}
