<?php
/**
 * BrightTally Plugin Deactivator
 *
 * Handles plugin deactivation tasks including cleanup and
 * scheduled event removal.
 *
 * @package BrightTally
 * @since 1.0.0
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

/**
 * BrightTally Plugin Deactivator Class
 *
 * @since 1.0.0
 */
class Bright_Tally_Deactivator {

    /**
     * Plugin deactivation method
     *
     * @since 1.0.0
     */
    public static function deactivate() {
        // Flush rewrite rules
        flush_rewrite_rules();
        
        // Clear any scheduled events
        wp_clear_scheduled_hook('bright_tally_sync_polls');
        
        // Clear any cached data
        self::clear_cache();
        
        // Log deactivation (only in debug mode)
        if (defined('WP_DEBUG') && WP_DEBUG) {
            error_log('BrightTally plugin deactivated successfully');
        }
    }
    
    /**
     * Clear plugin cache
     *
     * @since 1.0.0
     */
    private static function clear_cache() {
        // Clear any transients related to BrightTally
        global $wpdb;
        
        $wpdb->query(
            "DELETE FROM {$wpdb->options} 
             WHERE option_name LIKE '_transient_bright_tally_%' 
             OR option_name LIKE '_transient_timeout_bright_tally_%'"
        );
        
        // Log cache clearing (only in debug mode)
        if (defined('WP_DEBUG') && WP_DEBUG) {
            error_log('BrightTally cache cleared');
        }
    }
}
