/**
 * Save component for BrightTally Poll Block
 *
 * @package Bright_Tally
 * @since 1.0.0
 */

export default function save({ attributes }) {
	const { pollId, pollSlug, theme, showResults, allowVoting, width, height } = attributes;

	if (!pollId && !pollSlug) {
		return null;
	}

	// Build shortcode attributes
	const shortcodeAtts = [];
	shortcodeAtts.push(`id="${pollSlug || pollId}"`);

	if (theme && theme !== 'light') {
		shortcodeAtts.push(`theme="${theme}"`);
	}

	if (showResults) {
		shortcodeAtts.push('show_results="true"');
	}

	if (!allowVoting) {
		shortcodeAtts.push('allow_voting="false"');
	}

	if (width && width !== '100%') {
		shortcodeAtts.push(`width="${width}"`);
	}

	if (height && height !== 'auto') {
		shortcodeAtts.push(`height="${height}"`);
	}

	const shortcode = `[bright_tally ${shortcodeAtts.join(' ')}]`;

	return shortcode;
}

