<?php
/**
 * Onboarding wizard for first-time users
 *
 * @package Bright_Tally
 * @since 1.0.0
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}

// Get connection status
$is_connected = Bright_Tally_Token_Manager::is_connected();
$has_completed_onboarding = get_option('bright_tally_onboarding_completed', false);
$current_step = isset($_GET['step']) ? intval($_GET['step']) : 1;

// If connected and on step 1, move to step 2
if ($is_connected && $current_step == 1) {
    $current_step = 2;
}
?>
<div class="bright-tally-onboarding-overlay" id="bright-tally-onboarding">
    <div class="bright-tally-onboarding-modal">
        <div class="bright-tally-onboarding-header">
            <div class="bright-tally-onboarding-logo">
                <svg viewBox="0 0 24 24" fill="currentColor">
                    <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/>
                </svg>
            </div>
            <h1><?php _e('Welcome to BrightTally!', 'bright-tally'); ?></h1>
            <p><?php _e('Let\'s get you set up in just a few simple steps.', 'bright-tally'); ?></p>
        </div>
        
        <div class="bright-tally-onboarding-steps">
            <div class="bright-tally-step-indicator">
                <div class="step <?php echo $current_step >= 1 ? 'active' : ''; ?> <?php echo $current_step > 1 ? 'completed' : ''; ?>">
                    <span class="step-number">1</span>
                    <span class="step-label"><?php _e('Connect', 'bright-tally'); ?></span>
                </div>
                <div class="step-line"></div>
                <div class="step <?php echo $current_step >= 2 ? 'active' : ''; ?> <?php echo $current_step > 2 ? 'completed' : ''; ?>">
                    <span class="step-number">2</span>
                    <span class="step-label"><?php _e('Create Poll', 'bright-tally'); ?></span>
                </div>
                <div class="step-line"></div>
                <div class="step <?php echo $current_step >= 3 ? 'active' : ''; ?>">
                    <span class="step-number">3</span>
                    <span class="step-label"><?php _e('Embed', 'bright-tally'); ?></span>
                </div>
            </div>
            
            <div class="bright-tally-onboarding-content">
                <?php if ($current_step == 1): ?>
                    <!-- Step 1: Connect Account -->
                    <div class="onboarding-step-content">
                        <div class="step-icon">
                            <svg viewBox="0 0 24 24" fill="currentColor">
                                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                            </svg>
                        </div>
                        <h2><?php _e('Connect Your Account', 'bright-tally'); ?></h2>
                        <p><?php _e('Connect your BrightTally account to start creating beautiful polls. Start with our free plan - no credit card required!', 'bright-tally'); ?></p>
                        
                        <?php if (!$is_connected): ?>
                            <div class="onboarding-actions">
                                <a href="https://brighttally.com/wordpress/onboarding" target="_blank" class="button button-primary button-large">
                                    <?php _e('Get Started Free', 'bright-tally'); ?>
                                </a>
                                <button type="button" class="button button-large" id="onboarding-quick-connect">
                                    <?php _e('Sign In to Existing Account', 'bright-tally'); ?>
                                </button>
                                <button type="button" class="button button-large" id="onboarding-create-account">
                                    <?php _e('Create New Account', 'bright-tally'); ?>
                                </button>
                            </div>
                            <div class="onboarding-tip" style="margin-top: 20px;">
                                <strong><?php _e('Free Plan Includes:', 'bright-tally'); ?></strong>
                                <ul style="text-align: left; display: inline-block; margin-top: 10px;">
                                    <li><?php _e('Unlimited polls', 'bright-tally'); ?></li>
                                    <li><?php _e('Real-time results', 'bright-tally'); ?></li>
                                    <li><?php _e('Custom themes', 'bright-tally'); ?></li>
                                    <li><?php _e('WordPress integration', 'bright-tally'); ?></li>
                                </ul>
                            </div>
                            
                            <div id="onboarding-create-account-form" style="display: none; margin-top: 24px;">
                                <form id="onboarding-account-form">
                                    <div class="onboarding-form-grid">
                                        <div class="onboarding-form-group">
                                            <label for="onboarding_name"><?php _e('Full Name', 'bright-tally'); ?></label>
                                            <input type="text" id="onboarding_name" name="name" class="bright-tally-input" required>
                                        </div>
                                        <div class="onboarding-form-group">
                                            <label for="onboarding_email"><?php _e('Email', 'bright-tally'); ?></label>
                                            <input type="email" id="onboarding_email" name="email" class="bright-tally-input" required>
                                        </div>
                                        <div class="onboarding-form-group">
                                            <label for="onboarding_password"><?php _e('Password', 'bright-tally'); ?></label>
                                            <input type="password" id="onboarding_password" name="password" class="bright-tally-input" minlength="8" required>
                                        </div>
                                        <div class="onboarding-form-group">
                                            <label for="onboarding_password_confirm"><?php _e('Confirm Password', 'bright-tally'); ?></label>
                                            <input type="password" id="onboarding_password_confirm" name="password_confirm" class="bright-tally-input" required>
                                        </div>
                                    </div>
                                    <div class="onboarding-form-actions">
                                        <button type="submit" class="button button-primary"><?php _e('Create Account', 'bright-tally'); ?></button>
                                        <button type="button" class="button" onclick="jQuery('#onboarding-create-account-form').slideUp();"><?php _e('Cancel', 'bright-tally'); ?></button>
                                    </div>
                                </form>
                            </div>
                        <?php else: ?>
                            <div class="onboarding-success">
                                <div class="success-icon">
                                    <svg viewBox="0 0 24 24" fill="currentColor">
                                        <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"/>
                                    </svg>
                                </div>
                                <p><?php _e('Account connected successfully!', 'bright-tally'); ?></p>
                                <button type="button" class="button button-primary button-large" onclick="brightTallyOnboarding.nextStep(2)">
                                    <?php _e('Continue', 'bright-tally'); ?>
                                </button>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php elseif ($current_step == 2): ?>
                    <!-- Step 2: Create Poll -->
                    <div class="onboarding-step-content">
                        <div class="step-icon">
                            <svg viewBox="0 0 24 24" fill="currentColor">
                                <path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-5 14H7v-2h7v2zm3-4H7v-2h10v2zm0-4H7V7h10v2z"/>
                            </svg>
                        </div>
                        <h2><?php _e('Create Your First Poll', 'bright-tally'); ?></h2>
                        <p><?php _e('Polls are created on brighttally.com. Click the button below to open the poll builder in a new tab. Once you create a poll, it will automatically appear in your WordPress dashboard.', 'bright-tally'); ?></p>
                        
                        <div class="onboarding-actions">
                            <a href="https://brighttally.com/dashboard/polls/create" target="_blank" class="button button-primary button-large">
                                <?php _e('Create Poll on BrightTally.com', 'bright-tally'); ?>
                            </a>
                            <button type="button" class="button button-large" onclick="brightTallyOnboarding.nextStep(3)">
                                <?php _e('I\'ll do this later', 'bright-tally'); ?>
                            </button>
                        </div>
                        
                        <div class="onboarding-tip">
                            <strong><?php _e('Important:', 'bright-tally'); ?></strong>
                            <?php _e('All polls must be created on brighttally.com. The WordPress plugin is for embedding and managing polls that you\'ve already created. You can always create polls later from the BrightTally dashboard.', 'bright-tally'); ?>
                        </div>
                    </div>
                <?php elseif ($current_step == 3): ?>
                    <!-- Step 3: Embed Poll -->
                    <div class="onboarding-step-content">
                        <div class="step-icon">
                            <svg viewBox="0 0 24 24" fill="currentColor">
                                <path d="M19 19H5V5h7V3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2v-7h-2v7zM14 3v2h3.59l-9.83 9.83 1.41 1.41L19 6.41V10h2V3h-7z"/>
                            </svg>
                        </div>
                        <h2><?php _e('Embed Your Poll', 'bright-tally'); ?></h2>
                        <p><?php _e('Use shortcodes to embed polls anywhere on your WordPress site. Simply copy the shortcode and paste it into any post or page.', 'bright-tally'); ?></p>
                        
                        <div class="onboarding-code-example">
                            <code>[bright_tally id="your-poll-id"]</code>
                        </div>
                        
                        <div class="onboarding-actions">
                            <a href="<?php echo admin_url('admin.php?page=bright-tally-polls'); ?>" class="button button-primary button-large">
                                <?php _e('View My Polls', 'bright-tally'); ?>
                            </a>
                            <button type="button" class="button button-large" onclick="brightTallyOnboarding.complete()">
                                <?php _e('Finish Setup', 'bright-tally'); ?>
                            </button>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            
            <div class="bright-tally-onboarding-footer">
                <?php if ($current_step > 1): ?>
                    <button type="button" class="button" onclick="brightTallyOnboarding.previousStep()">
                        <?php _e('← Previous', 'bright-tally'); ?>
                    </button>
                <?php endif; ?>
                
                <div class="onboarding-footer-right">
                    <a href="<?php echo esc_url(Bright_Tally_URL_Helper::get_docs_url() . '/wordpress'); ?>" target="_blank" rel="noopener noreferrer" class="button-link" style="margin-right: 15px;">
                        <?php _e('View Documentation', 'bright-tally'); ?>
                    </a>
                    <button type="button" class="button-link" onclick="brightTallyOnboarding.skip()">
                        <?php _e('Skip Setup', 'bright-tally'); ?>
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

