<?php
/**
 * Admin dashboard display
 *
 * @package Bright_Tally
 * @since 1.0.0
 */

// Prevent direct access
if (!defined('ABSPATH')) {
    exit;
}
?>

<?php
$is_connected = Bright_Tally_Token_Manager::is_connected();
$user_data = Bright_Tally_Token_Manager::get_user_data();
$connected_email = $user_data['email'] ?? '';
$api_url = '';
$docs_base_url = Bright_Tally_URL_Helper::get_docs_url();
$polls_error = '';
$stats = array(
    'total_polls' => 0,
    'active_polls' => 0,
    'total_responses' => 0,
    'forms_count' => null,
);
$recent_polls = array();

if ($is_connected) {
    $api = new Bright_Tally_API();
    $api_url = Bright_Tally_URL_Helper::get_api_url();
    $polls_response = $api->get_polls();

    if (is_wp_error($polls_response)) {
        $polls_error = $polls_response->get_error_message();
    } else {
        $polls_data = array();
        if (isset($polls_response['data']) && is_array($polls_response['data'])) {
            $polls_data = $polls_response['data'];
        } elseif (is_array($polls_response)) {
            $polls_data = $polls_response;
        }

        $polls_meta = isset($polls_response['meta']) && is_array($polls_response['meta']) ? $polls_response['meta'] : array();
        $stats['total_polls'] = isset($polls_meta['total']) ? (int) $polls_meta['total'] : count($polls_data);
        $stats['active_polls'] = count(array_filter($polls_data, function($poll) {
            $status = strtolower($poll['status'] ?? '');
            if (empty($status) && !empty($poll['is_active'])) {
                $status = 'active';
            }
            return in_array($status, array('active', 'published', 'live', 'open'), true);
        }));
        $stats['total_responses'] = array_reduce($polls_data, function($carry, $poll) {
            $count = isset($poll['response_count']) ? (int) $poll['response_count'] : 0;
            return $carry + $count;
        }, 0);

        if (isset($polls_meta['forms_total'])) {
            $stats['forms_count'] = (int) $polls_meta['forms_total'];
        }

        $recent_polls = array_slice($polls_data, 0, 3);
    }
}

$docs_quick_links = array(
    array(
        'title' => __('Download the WordPress plugin', 'bright-tally'),
        'slug' => 'wordpress/setup/downloading-the-wordpress-plugin',
        'summary' => __('Generate the latest BrightTally plugin ZIP and install it on your WordPress site.', 'bright-tally'),
        'audience' => __('Site admins', 'bright-tally'),
        'subscription' => __('All plans', 'bright-tally'),
    ),
    array(
        'title' => __('Connect the WordPress plugin', 'bright-tally'),
        'slug' => 'wordpress/setup/connecting-the-wordpress-plugin',
        'summary' => __('Authorize WordPress and BrightTally, configure callbacks, and verify the OAuth handshake.', 'bright-tally'),
        'audience' => __('Site admins', 'bright-tally'),
        'subscription' => __('All plans', 'bright-tally'),
    ),
    array(
        'title' => __('Embed polls & forms in WordPress', 'bright-tally'),
        'slug' => 'wordpress/manage/embedding-polls-and-forms',
        'summary' => __('Use shortcodes, the block editor, and widgets to publish interactive experiences.', 'bright-tally'),
        'audience' => __('Content editors', 'bright-tally'),
        'subscription' => __('Starter and above', 'bright-tally'),
    ),
    array(
        'title' => __('Troubleshoot OAuth & sync issues', 'bright-tally'),
        'slug' => 'wordpress/troubleshooting/oauth-errors',
        'summary' => __('Confirm callbacks, rotate credentials, and keep WordPress & BrightTally in sync.', 'bright-tally'),
        'audience' => __('Technical staff', 'bright-tally'),
        'subscription' => __('Pro / Agency', 'bright-tally'),
    ),
    array(
        'title' => __('Roles, plans & access levels', 'bright-tally'),
        'slug' => 'account/permissions/plan-access',
        'summary' => __('See which features unlock with each subscription and how to invite collaborators.', 'bright-tally'),
        'audience' => __('Workspace owners', 'bright-tally'),
        'subscription' => __('All plans', 'bright-tally'),
    ),
);
?>

<div class="bright-tally-admin-page">
    <div class="bright-tally-admin-content">
        <div class="bright-tally-header">
            <div class="bright-tally-header-content">
                <div class="bright-tally-logo">
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M12 2L2 7l10 5 10-5-10-5zM2 17l10 5 10-5M2 12l10 5 10-5"/>
                    </svg>
                </div>
                <h1><?php _e('BrightTally Dashboard', 'bright-tally'); ?></h1>
                <?php if ($is_connected): ?>
                    <?php // This will generally be overridden by admin.js updateConnectionUI function when the connection status is updated ?>
                    <p>
                        <?php echo sprintf(
                            /* translators: %s is the connected email address */
                            __('Connected as %s. Here is what\'s happening with your polls right now.', 'bright-tally'),
                            '<strong>' . esc_html($connected_email) . '</strong>'
                        ); ?>
                    </p>

                    <p>
                        <?php echo sprintf(
                            /* translators: %s is the connected API url */
                            __('Connected to BrightTally at %s.', 'bright-tally'),
                            '<strong>' . esc_html($api_url) . '</strong>'
                        ); ?>
                    </p>
                <?php else: ?>
                    <p><?php _e('Connect BrightTally to WordPress to publish polls and forms with live analytics on any page.', 'bright-tally'); ?></p>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="bright-tally-dashboard">
            <?php if ($is_connected): ?>
                <div class="bright-tally-welcome bright-tally-welcome-connected">
                    <div class="connected-chip">
                        <span class="status-indicator connected"></span>
                        <?php _e('BrightTally connection active', 'bright-tally'); ?>
                    </div>
                    <h2><?php _e('You\'re all set!', 'bright-tally'); ?></h2>
                    <p><?php _e('Ready to ship your next experience? Jump into recent polls, share embeds, or explore new forms tooling below.', 'bright-tally'); ?></p>
                    <div class="connected-actions">
                        <a href="<?php echo admin_url('admin.php?page=bright-tally-polls'); ?>" class="button button-primary">
                            <?php _e('Open Poll Library', 'bright-tally'); ?>
                        </a>
                        <a href="https://brighttally.com/dashboard/polls/create" target="_blank" rel="noopener noreferrer" class="button">
                            <?php _e('Create Poll in BrightTally', 'bright-tally'); ?>
                        </a>
                        <button type="button" class="button button-secondary bright-tally-disconnect" data-context="dashboard">
                            <?php _e('Disconnect', 'bright-tally'); ?>
                        </button>
                    </div>
                    <p class="disconnect-note">
                        <?php _e('Disconnecting only stops new admin actions from this site. Your public embeds keep working with their last synced configuration until you reconnect.', 'bright-tally'); ?>
                        <strong><?php _e('Important:', 'bright-tally'); ?></strong> <?php _e('Disconnecting or uninstalling this plugin will NOT close or delete your BrightTally account. Your account, polls, and data remain safe on brighttally.com.', 'bright-tally'); ?>
                    </p>
                </div>

                <?php if (!empty($polls_error)): ?>
                    <div class="bright-tally-inline-notice notice-error">
                        <p><?php echo esc_html($polls_error); ?></p>
                        <p>
                            <a href="<?php echo esc_url($docs_base_url . '/wordpress/troubleshooting/oauth-errors'); ?>" target="_blank" rel="noopener noreferrer">
                                <?php _e('Review the troubleshooting guide', 'bright-tally'); ?>
                            </a>
                        </p>
                    </div>
                <?php else: ?>
                    <div class="bright-tally-stats-grid">
                        <div class="bright-tally-stat-card">
                            <span class="stat-label"><?php _e('Total Polls', 'bright-tally'); ?></span>
                            <span class="stat-value"><?php echo esc_html(number_format_i18n($stats['total_polls'])); ?></span>
                            <span class="stat-footnote"><?php _e('Including drafts and archived polls', 'bright-tally'); ?></span>
                        </div>
                        <div class="bright-tally-stat-card">
                            <span class="stat-label"><?php _e('Active Polls', 'bright-tally'); ?></span>
                            <span class="stat-value"><?php echo esc_html(number_format_i18n($stats['active_polls'])); ?></span>
                            <span class="stat-footnote">
                                <?php _e('Publish status synced from BrightTally', 'bright-tally'); ?>
                            </span>
                        </div>
                        <div class="bright-tally-stat-card">
                            <span class="stat-label"><?php _e('Responses Collected', 'bright-tally'); ?></span>
                            <span class="stat-value"><?php echo esc_html(number_format_i18n($stats['total_responses'])); ?></span>
                            <span class="stat-footnote">
                                <?php _e('Real-time totals based on recent sync', 'bright-tally'); ?>
                            </span>
                        </div>
                    </div>

                    <div class="bright-tally-section">
                        <div class="section-heading">
                            <h3><?php _e('Latest Poll Activity', 'bright-tally'); ?></h3>
                            <a href="<?php echo admin_url('admin.php?page=bright-tally-polls'); ?>" class="button button-small">
                                <?php _e('Manage Polls', 'bright-tally'); ?>
                            </a>
                        </div>
                        <?php if (!empty($recent_polls)): ?>
                            <ul class="bright-tally-recent-list">
                                <?php foreach ($recent_polls as $poll): ?>
                                    <li class="recent-item">
                                        <div class="recent-item-header">
                                            <strong><?php echo esc_html($poll['title'] ?? __('Untitled poll', 'bright-tally')); ?></strong>
                                            <span class="recent-status status-<?php echo esc_attr(strtolower($poll['status'] ?? 'draft')); ?>">
                                                <?php echo esc_html(ucfirst($poll['status'] ?? __('Draft', 'bright-tally'))); ?>
                                            </span>
                                        </div>
                                        <div class="recent-meta">
                                            <span>
                                                <?php
                                                $respondents = isset($poll['response_count']) ? (int) $poll['response_count'] : 0;
                                                echo esc_html(sprintf(_n('%s response', '%s responses', $respondents, 'bright-tally'), number_format_i18n($respondents)));
                                                ?>
                                            </span>
                                            <?php if (!empty($poll['updated_at'])): ?>
                                                <span>
                                                    <?php echo esc_html(sprintf(
                                                        __('Updated %s', 'bright-tally'),
                                                        date_i18n(get_option('date_format'), strtotime($poll['updated_at']))
                                                    )); ?>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="recent-actions">
                                            <?php if (!empty($poll['slug'])): ?>
                                                <button class="button button-secondary get-shortcode" data-poll-id="<?php echo esc_attr($poll['id']); ?>" data-poll-slug="<?php echo esc_attr($poll['slug']); ?>">
                                                    <?php _e('Get Shortcode', 'bright-tally'); ?>
                                                </button>
                                            <?php endif; ?>
                                            <?php if (!empty($poll['url'])): ?>
                                                <a href="<?php echo esc_url($poll['url']); ?>" target="_blank" rel="noopener noreferrer" class="button">
                                                    <?php _e('View in BrightTally', 'bright-tally'); ?>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        <?php else: ?>
                            <div class="bright-tally-empty-state">
                                <h4><?php _e('No polls yet', 'bright-tally'); ?></h4>
                                <p><?php _e('Create a poll in BrightTally to see it appear here in seconds.', 'bright-tally'); ?></p>
                                <a href="https://brighttally.com/dashboard/polls/create" target="_blank" rel="noopener noreferrer" class="button button-primary">
                                    <?php _e('Create Your First Poll', 'bright-tally'); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <div class="bright-tally-section forms-section">
                    <div class="section-heading">
                        <h3><?php _e('Forms Overview', 'bright-tally'); ?></h3>
                        <a href="<?php echo esc_url($docs_base_url . '/roadmap/forms-beta'); ?>" target="_blank" rel="noopener noreferrer" class="button button-small">
                            <?php _e('View forms roadmap', 'bright-tally'); ?>
                        </a>
                    </div>
                    <div class="forms-summary">
                        <?php if (!is_null($stats['forms_count'])): ?>
                            <div class="forms-count">
                                <span class="forms-value"><?php echo esc_html(number_format_i18n($stats['forms_count'])); ?></span>
                                <span class="forms-label"><?php _e('Published forms', 'bright-tally'); ?></span>
                            </div>
                        <?php else: ?>
                            <div class="forms-status">
                                <p><?php _e('BrightTally forms are rolling out to teams over the next few weeks. You\'ll see forms stats here as soon as your workspace has access.', 'bright-tally'); ?></p>
                            </div>
                        <?php endif; ?>
                        <p class="forms-note">
                            <?php _e('Forms share the same embed tools as polls. Content editors can drop them into posts once forms are enabled for your plan.', 'bright-tally'); ?>
                        </p>
                    </div>
                </div>
            <?php else: ?>
            <div class="bright-tally-welcome">
                <h2><?php _e('Welcome to BrightTally!', 'bright-tally'); ?></h2>
                    <p><?php _e('Connect your account to unlock live polls, forms (beta), and analytics directly inside WordPress. You only need to do this once.', 'bright-tally'); ?></p>
            </div>
        
        <div class="bright-tally-cards">
            <div class="bright-tally-card">
                <div class="bright-tally-card-icon">
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z"/>
                    </svg>
                </div>
                        <h3><?php _e('Quick Connect', 'bright-tally'); ?></h3>
                        <p><?php _e('Use OAuth to connect in seconds. We handle API keys, secrets, and secure storage automatically.', 'bright-tally'); ?></p>
                <a href="<?php echo admin_url('admin.php?page=bright-tally-settings'); ?>" class="button button-primary">
                    <?php _e('Connect Account', 'bright-tally'); ?>
                </a>
            </div>
            
            <div class="bright-tally-card">
                <div class="bright-tally-card-icon">
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-5 14H7v-2h7v2zm3-4H7v-2h10v2zm0-4H7V7h10v2z"/>
                    </svg>
                </div>
                        <h3><?php _e('Preview the Library', 'bright-tally'); ?></h3>
                        <p><?php _e('Once you connect, your BrightTally polls sync here automatically so editors can embed them with a click.', 'bright-tally'); ?></p>
                <a href="<?php echo admin_url('admin.php?page=bright-tally-polls'); ?>" class="button">
                            <?php _e('See How Polls Sync', 'bright-tally'); ?>
                </a>
            </div>
            
            <div class="bright-tally-card">
                <div class="bright-tally-card-icon">
                    <svg viewBox="0 0 24 24" fill="currentColor">
                        <path d="M9.5 3A6.5 6.5 0 0 1 16 9.5c0 1.61-.59 3.09-1.56 4.23l.27.27h.79l5 5-1.5 1.5-5-5v-.79l-.27-.27A6.516 6.516 0 0 1 9.5 16 6.5 6.5 0 0 1 3 9.5 6.5 6.5 0 0 1 9.5 3m0 2C7 5 5 7 5 9.5S7 14 9.5 14 14 12 14 9.5 12 5 9.5 5z"/>
                    </svg>
                </div>
                        <h3><?php _e('Need a walkthrough?', 'bright-tally'); ?></h3>
                        <p><?php _e('Open the help panel below for plugin docs, including plan-specific notes for admins and contributors.', 'bright-tally'); ?></p>
                        <button type="button" class="button" data-toggle="docs-help">
                            <?php _e('Show Help', 'bright-tally'); ?>
                        </button>
                    </div>
                </div>
            <?php endif; ?>

            <div class="bright-tally-support">
                <div class="support-header">
                    <h3><?php _e('Need guidance?', 'bright-tally'); ?></h3>
                    <div class="support-actions">
                        <button type="button" class="button button-primary" data-toggle="docs-help">
                    <?php _e('Show Help', 'bright-tally'); ?>
                        </button>
                        <a href="<?php echo esc_url($docs_base_url); ?>" class="button" target="_blank" rel="noopener noreferrer">
                            <?php _e('Browse Full Docs', 'bright-tally'); ?>
                </a>
            </div>
        </div>
                <p class="support-note">
                    <?php _e('Documentation highlights what each subscription level includes. Admin-only content is still visible so you can plan upgrades without guesswork.', 'bright-tally'); ?>
                </p>

                <div id="bright-tally-help-panel" class="bright-tally-help-panel" style="display: none;">
                    <form id="bright-tally-help-search" class="help-search">
                        <label for="bright-tally-help-query" class="screen-reader-text"><?php _e('Search documentation', 'bright-tally'); ?></label>
                        <input type="search" id="bright-tally-help-query" name="search" placeholder="<?php esc_attr_e('Search docs (e.g., shortcode, troubleshooting)...', 'bright-tally'); ?>">
                        <button type="submit" class="button button-primary">
                            <?php _e('Search', 'bright-tally'); ?>
                        </button>
                    </form>

                    <div class="help-links">
                        <?php foreach ($docs_quick_links as $doc): ?>
                            <?php
                            $doc_url = $docs_base_url . '/' . ltrim($doc['slug'], '/');
                            ?>
                            <a href="<?php echo esc_url($doc_url); ?>" class="help-link" target="_blank" rel="noopener noreferrer">
                                <div class="help-link-header">
                                    <h4><?php echo esc_html($doc['title']); ?></h4>
                                    <span class="help-audience"><?php echo esc_html($doc['audience']); ?></span>
                                </div>
                                <p><?php echo esc_html($doc['summary']); ?></p>
                                <span class="help-subscription"><?php echo esc_html($doc['subscription']); ?></span>
                            </a>
                        <?php endforeach; ?>
                    </div>

                    <div class="help-footer">
                        <p>
                            <?php _e('Prefer a human? Reach out via the in-app messenger or email hello@brighttally.com and reference your workspace slug for the fastest response.', 'bright-tally'); ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
