# BrightTally WordPress Plugin - User Guide

A comprehensive guide for using the BrightTally WordPress plugin to embed interactive polls and surveys on your website.

## Table of Contents

1. [Getting Started](#getting-started)
2. [Connecting Your Account](#connecting-your-account)
3. [Creating Polls](#creating-polls)
4. [Embedding Polls](#embedding-polls)
5. [Managing Polls](#managing-polls)
6. [Customization Options](#customization-options)
7. [Best Practices](#best-practices)
8. [Common Use Cases](#common-use-cases)

## Getting Started

### Installation

1. **Download the Plugin**
   - Download the BrightTally plugin zip file
   - Or install from WordPress plugin repository (if available)

2. **Install in WordPress**
   - Go to **Plugins > Add New**
   - Click **"Upload Plugin"**
   - Choose the zip file and click **"Install Now"**
   - Click **"Activate Plugin"**

3. **Access the Plugin**
   - After activation, you'll see **"BrightTally"** in your WordPress admin menu
   - The onboarding wizard will guide you through setup

## Connecting Your Account

### Option 1: OAuth Connection (Recommended)

**Why OAuth?**
- Most secure method
- No need to copy/paste API keys
- Automatic token refresh
- One-click setup

**Steps:**
1. Go to **BrightTally > Settings**
2. Click **"Sign In to BrightTally"**
3. A popup window will open
4. Sign in to your BrightTally account (or create one)
5. Click **"Authorize"** to allow WordPress access
6. The popup will close and your account will be connected

**Troubleshooting:**
- If popup doesn't open, check browser popup blocker settings
- Allow popups for your WordPress site
- Try a different browser if issues persist

### Option 2: Create New Account

**Steps:**
1. Go to **BrightTally > Settings**
2. Click **"Create New Account"**
3. Fill in the form:
   - **Full Name**: Your name
   - **Email**: Your email address
   - **Password**: At least 8 characters
   - **Confirm Password**: Re-enter your password
4. Click **"Create Account & Connect"**
5. Your account will be created and connected automatically

### Option 3: Manual API Token Setup (Advanced - Pro/Agency/Enterprise Only)

**When to use:**
- You have a Pro, Agency, or Enterprise plan
- OAuth is not working
- You prefer manual configuration
- You need programmatic access without OAuth

**Note:** OAuth connection is recommended and works for all plans. API tokens are only available for paid plans (Pro, Agency, Enterprise).

**Steps:**
1. Go to **BrightTally > Settings**
2. Click **"Enter API Token"**
3. Get your API token from [brighttally.com](https://brighttally.com):
   - Sign in to your account
   - Click your profile menu (top right)
   - If you have a Pro, Agency, or Enterprise plan, you'll see **API Tokens**
   - Click **"Create Token"**
   - Give it a name (e.g., "WordPress Plugin")
   - Copy the token (you'll only see it once!)
4. Paste the API token in WordPress
5. Set API URL (default: `https://brighttally.com`)
6. Click **"Save Changes"**
7. Click **"Test Connection"** to verify

**Don't see API Tokens?** You're on the Free plan. Use OAuth connection instead (Option 1 above) - it's easier and works great!

## Creating Polls

### Method 1: Create in BrightTally Dashboard

1. Go to [brighttally.com](https://brighttally.com) and sign in
2. Click **"Create Poll"** or go to **Dashboard > Polls > New**
3. Fill in poll details:
   - **Title**: Your poll question
   - **Description**: Optional context or instructions
   - **Options**: Add poll options
   - **Settings**: Configure poll behavior
4. Click **"Create"** or **"Save"**
5. Copy the poll slug/ID
6. Use it in WordPress shortcodes

### Method 2: Use Quick Create Link

1. Go to **BrightTally > Polls** in WordPress
2. Click **"Create New Poll"** button
3. This opens BrightTally dashboard in a new tab
4. Create your poll
5. Return to WordPress and refresh the polls list

## Embedding Polls

### Using Shortcodes

#### Basic Shortcode

```
[bright_tally id="your-poll-slug"]
```

**Where to use:**
- Posts
- Pages
- Widgets (Text widget)
- Custom post types
- Theme templates

#### Shortcode with Options

```
[bright_tally id="your-poll-slug" theme="dark" show_results="true" allow_voting="true"]
```

### Using Gutenberg Block

1. **Add the Block**
   - In post/page editor, click **"+"** (Add Block)
   - Search for **"BrightTally"**
   - Click to add the block

2. **Select a Poll**
   - Click **"Select Poll"** button
   - Browse your polls or use search
   - Click on a poll to select it

3. **Configure Settings**
   - **Theme**: Light or Dark
   - **Show Results**: Toggle on/off
   - **Allow Voting**: Toggle on/off
   - **Width**: Custom width (e.g., 600px, 100%)
   - **Height**: Custom height (e.g., auto, 500px)

4. **Preview**
   - See live preview in editor
   - Adjust settings as needed

5. **Publish**
   - Click **"Publish"** or **"Update"**
   - Poll appears on your site

### Getting Shortcodes from Dashboard

1. Go to **BrightTally > Polls**
2. Find the poll you want to embed
3. Click **"Get Shortcode"** button
4. A modal will open with:
   - Basic shortcode
   - Options to customize
   - Copy button
5. Click **"Copy"** and paste where needed

## Managing Polls

### Viewing All Polls

1. Go to **BrightTally > Polls**
2. See all polls from your account:
   - Poll title
   - Status (Active, Draft, Closed)
   - Vote count
   - Creation date
   - Actions (Get Shortcode, View)

### Searching Polls

- Use the search box at the top
- Type poll name or title
- Results filter automatically

### Filtering Polls

- Click filter buttons:
  - **All**: Show all polls
  - **Active**: Only active polls
  - **Draft**: Only draft polls
  - **Closed**: Only closed polls

### Refreshing Poll Data

- Click **"Refresh"** button
- Polls auto-refresh every 30 seconds
- Updates vote counts and status

## Customization Options

### Themes

**Light Theme** (Default)
- Clean, bright appearance
- Best for light backgrounds
- Use: `theme="light"` or omit

**Dark Theme**
- Modern, dark appearance
- Best for dark backgrounds
- Use: `theme="dark"`

### Sizing

**Width Options:**
- `width="100%"` - Full width (default)
- `width="600px"` - Fixed width
- `width="80%"` - Percentage width

**Height Options:**
- `height="auto"` - Auto-adjust (default)
- `height="500px"` - Fixed height
- `height="600px"` - Custom height

### Display Options

**Show Results:**
- `show_results="true"` - Display poll results
- `show_results="false"` - Hide results (default)

**Allow Voting:**
- `allow_voting="true"` - Visitors can vote (default)
- `allow_voting="false"` - Display only (no voting)

### Example Combinations

**Results Only (No Voting):**
```
[bright_tally id="my-poll" show_results="true" allow_voting="false"]
```

**Dark Theme, Fixed Width:**
```
[bright_tally id="my-poll" theme="dark" width="600px"]
```

**Full Customization:**
```
[bright_tally id="my-poll" theme="dark" width="100%" show_results="true" allow_voting="true"]
```

## Best Practices

### Poll Design

1. **Clear Questions**
   - Keep questions concise
   - Use simple language
   - Avoid ambiguity

2. **Relevant Options**
   - Provide meaningful choices
   - Include "Other" option if needed
   - Limit to 5-7 options for best UX

3. **Descriptions**
   - Add context when needed
   - Explain the purpose
   - Set expectations

### Placement

1. **Above the Fold**
   - Place important polls near top
   - Ensure visibility
   - Don't bury in long content

2. **Relevant Context**
   - Place polls near related content
   - Match poll topic to page topic
   - Use polls to engage readers

3. **Mobile Consideration**
   - Test on mobile devices
   - Ensure readability
   - Check touch interactions

### Performance

1. **Limit Polls Per Page**
   - Don't overload pages
   - 1-3 polls per page is ideal
   - Consider page load time

2. **Cache Settings**
   - Adjust cache duration in settings
   - Balance freshness vs performance
   - Default 5 minutes is usually good

3. **Lazy Loading**
   - Polls load lazily by default
   - Improves initial page load
   - Better user experience

## Common Use Cases

### Blog Posts

**Use Case:** Engage readers with opinion polls

**Example:**
```
After reading this article, what's your opinion?

[bright_tally id="article-opinion-poll"]
```

### Product Pages

**Use Case:** Gather feedback on products

**Example:**
```
What feature would you like to see next?

[bright_tally id="product-feedback" theme="dark"]
```

### Landing Pages

**Use Case:** Collect preferences or interests

**Example:**
```
What interests you most?

[bright_tally id="landing-page-poll" show_results="true"]
```

### News Articles

**Use Case:** Get reader opinions on current events

**Example:**
```
What do you think about this story?

[bright_tally id="news-poll"]
```

### Surveys

**Use Case:** Collect detailed feedback

**Example:**
```
Help us improve by answering this survey:

[bright_tally id="customer-survey" allow_voting="true"]
```

### Results Display

**Use Case:** Show poll results without voting

**Example:**
```
Here are the results from our recent poll:

[bright_tally id="results-poll" show_results="true" allow_voting="false"]
```

## Troubleshooting

### Poll Not Appearing

1. Check poll ID is correct
2. Verify poll is active in BrightTally
3. Check shortcode syntax
4. Clear WordPress cache
5. Check browser console for errors

### Connection Issues

1. Verify account is connected
2. Test connection in Settings
3. Try reconnecting account
4. Check API URL is correct
5. Contact support if needed

**Important:** Disconnecting or uninstalling the plugin will NOT close or delete your BrightTally account. Your account, polls, and all data remain safe on brighttally.com. You can reconnect at any time.

### Styling Problems

1. Try different theme
2. Adjust width/height
3. Check for CSS conflicts
4. Test in different browser
5. Disable other plugins temporarily

## Support

Need help? Get support at:
- **Documentation**: Check README.md
- **BrightTally Support**: [brighttally.com/support](https://brighttally.com/support)
- **WordPress Settings**: Use connection test tool

---

**Happy Polling!** 🎉

