# BrightTally WordPress Plugin

Embed interactive polls and surveys from BrightTally directly into your WordPress site. Create engaging content with real-time results and analytics.

## Table of Contents

- [Features](#features)
- [Installation](#installation)
- [Quick Start](#quick-start)
- [Configuration](#configuration)
- [Usage](#usage)
  - [Shortcodes](#shortcodes)
  - [Gutenberg Block](#gutenberg-block)
- [Managing Polls](#managing-polls)
- [Troubleshooting](#troubleshooting)
- [Support](#support)
- [Changelog](#changelog)

## Features

- ✅ **Easy Integration**: Simple shortcode system and Gutenberg block for embedding polls
- ✅ **OAuth Authentication**: Secure connection to your BrightTally account
- ✅ **Account Creation**: Create a BrightTally account directly from WordPress
- ✅ **Real-time Results**: Live poll results and analytics
- ✅ **Customizable Themes**: Light and dark themes to match your site
- ✅ **Responsive Design**: Looks great on all devices
- ✅ **Multiple Poll Types**: Support for various poll and survey formats
- ✅ **Voting Controls**: Enable or disable voting as needed
- ✅ **Results Display**: Show or hide poll results
- ✅ **Visual Poll Picker**: Browse and select polls from your dashboard
- ✅ **Onboarding Wizard**: Step-by-step setup guide for first-time users

## Installation

### Prerequisites

- WordPress 5.0 or higher
- PHP 7.4 or higher
- A BrightTally account (you can create one during setup)

### Method 1: WordPress Admin Upload

1. Go to **Plugins > Add New** in your WordPress admin
2. Click **"Upload Plugin"**
3. Choose the `bright-tally.zip` file
4. Click **"Install Now"**
5. Click **"Activate Plugin"**

### Method 2: Manual Installation

1. Download the plugin files
2. Extract the `bright-tally` folder
3. Upload the folder to `/wp-content/plugins/` directory via FTP
4. Go to **Plugins** in WordPress admin
5. Find **BrightTally** and click **"Activate"**

## Quick Start

1. **Activate the Plugin**
   - After activation, you'll see the BrightTally menu in your WordPress admin

2. **Connect Your Account**
   - Go to **BrightTally > Settings**
   - Click **"Sign In to BrightTally"** or **"Create New Account"**
   - Follow the OAuth flow to connect your account

3. **Create Your First Poll**
   - Go to [brighttally.com](https://brighttally.com) and create a poll
   - Or use the link in **BrightTally > Polls** to create one

4. **Embed the Poll**
   - Go to **BrightTally > Polls** in WordPress
   - Click **"Get Shortcode"** on any poll
   - Copy and paste the shortcode into any post or page

## Configuration

### Account Connection

The plugin supports two connection methods:

#### OAuth Connection (Recommended)

1. Go to **BrightTally > Settings**
2. Click **"Sign In to BrightTally"**
3. A popup will open - sign in to your BrightTally account
4. Authorize the WordPress plugin
5. Your account will be automatically connected

#### Create New Account

1. Go to **BrightTally > Settings**
2. Click **"Create New Account"**
3. Fill in your name, email, and password
4. Your account will be created and connected automatically

#### Manual API Token Setup (Advanced - Pro/Agency/Enterprise Only)

**Note:** This is optional and only available for Pro, Agency, and Enterprise plans. OAuth connection (above) is recommended and works for all plans.

1. Go to **BrightTally > Settings**
2. Click **"Enter API Token"**
3. Get your API token from BrightTally (requires Pro plan or higher):
   - Log in to [brighttally.com](https://brighttally.com)
   - Click your profile menu (top right)
   - If you have a Pro, Agency, or Enterprise plan, you'll see **API Tokens**
   - Create a new token and copy it
4. Paste the token in WordPress
5. Set the API URL (default: `https://brighttally.com`)
6. Click **"Save Changes"**
7. Test the connection

**Important:** If you don't see API Tokens in your profile menu, you're on the Free plan. Use OAuth connection instead (recommended for all plans).

### Settings Options

- **API Token** (Optional): Your BrightTally API token for programmatic access (not required if using OAuth)
- **API URL**: Base URL for BrightTally API (default: `https://brighttally.com`)
- **Default Theme**: Choose light or dark theme for polls
- **Cache Duration**: How long to cache poll data (60-3600 seconds)

## Usage

### Shortcodes

#### Basic Shortcode

```
[bright_tally id="your-poll-slug"]
```

#### Advanced Shortcode with Options

```
[bright_tally id="your-poll-slug" theme="dark" width="100%" show_results="true" allow_voting="true"]
```

#### Available Attributes

| Attribute | Description | Default | Options |
|-----------|-------------|---------|---------|
| `id` | Poll ID or slug (required) | - | Any valid poll slug |
| `theme` | Poll theme | `light` | `light`, `dark` |
| `width` | Poll width | `100%` | Any CSS width value |
| `height` | Poll height | `auto` | Any CSS height value |
| `show_results` | Show poll results | `false` | `true`, `false` |
| `allow_voting` | Allow visitors to vote | `true` | `true`, `false` |

#### Shortcode Examples

**Display poll with dark theme:**
```
[bright_tally id="my-poll" theme="dark"]
```

**Show results only (no voting):**
```
[bright_tally id="my-poll" show_results="true" allow_voting="false"]
```

**Custom width:**
```
[bright_tally id="my-poll" width="600px"]
```

**Full customization:**
```
[bright_tally id="my-poll" theme="dark" width="100%" show_results="true" allow_voting="true"]
```

### Gutenberg Block

1. **Add the Block**
   - In the Gutenberg editor, click the **"+"** button
   - Search for **"BrightTally"**
   - Click to add the block

2. **Select a Poll**
   - Click **"Select Poll"** in the block
   - Browse your polls or search by name
   - Click on a poll to select it

3. **Configure Options**
   - **Theme**: Choose light or dark
   - **Show Results**: Toggle to show/hide results
   - **Allow Voting**: Toggle to enable/disable voting
   - **Width**: Set custom width
   - **Height**: Set custom height

4. **Preview**
   - The block shows a preview of your poll
   - Changes are reflected immediately

5. **Publish**
   - Click **"Publish"** or **"Update"**
   - The poll will appear on your site

### Using in Widgets

You can use shortcodes in any widget that supports them:

1. Go to **Appearance > Widgets**
2. Add a **Text** or **Shortcode** widget
3. Paste your BrightTally shortcode
4. Save the widget

## Managing Polls

### View All Polls

1. Go to **BrightTally > Polls** in WordPress admin
2. Browse all your polls from your BrightTally account
3. See poll status, vote counts, and creation dates

### Get Shortcode

1. Go to **BrightTally > Polls**
2. Find the poll you want to embed
3. Click **"Get Shortcode"**
4. Copy the shortcode
5. Paste it into any post, page, or widget

### Refresh Polls

- Click the **"Refresh"** button to update poll data
- Polls auto-refresh every 30 seconds when on the polls page

### Search and Filter

- Use the search box to find polls by name
- Filter by status: All, Active, Draft, or Closed

## Troubleshooting

### Connection Issues

**Problem:** Cannot connect to BrightTally account

**Solutions:**
- Check your internet connection
- Verify the API URL is correct (should be `https://brighttally.com`)
- Try disconnecting and reconnecting your account
- Check browser console for errors
- Ensure popups are allowed in your browser

**Problem:** OAuth popup doesn't open

**Solutions:**
- Allow popups for your WordPress site
- Try a different browser
- Check browser popup blocker settings
- Use manual API token setup as alternative (see Advanced Configuration)

### Poll Display Issues

**Problem:** Poll doesn't appear on page

**Solutions:**
- Verify the poll ID/slug is correct
- Check that the poll is active in your BrightTally account
- Verify shortcode syntax is correct
- Check browser console for JavaScript errors
- Try clearing WordPress cache

**Problem:** Poll shows error message

**Solutions:**
- Verify your account is connected
- Check API connection in settings
- Ensure poll exists and is active
- Try refreshing the page

### Styling Issues

**Problem:** Poll styling conflicts with theme

**Solutions:**
- Try switching between light and dark themes
- Adjust width and height attributes
- Check for CSS conflicts in browser inspector
- Contact support if issue persists

**Problem:** Poll not responsive on mobile

**Solutions:**
- Ensure width is set to `100%` or responsive value
- Check your theme's mobile CSS
- Test in different browsers/devices

### Performance Issues

**Problem:** Slow page loading with polls

**Solutions:**
- Reduce cache duration in settings
- Limit number of polls per page
- Check server performance
- Optimize images in polls

### Account Issues

**Problem:** Cannot create account

**Solutions:**
- Verify email is valid and not already registered
- Ensure password is at least 8 characters
- Check all required fields are filled
- Try creating account directly on brighttally.com

**Problem:** Account disconnected

**Solutions:**
- Reconnect via Settings page
- Check token hasn't expired
- Verify API URL is correct
- Contact support if issue persists

**Important:** Disconnecting or uninstalling the plugin will NOT close or delete your BrightTally account. Your account, polls, and all data remain safe on brighttally.com. You can reconnect at any time.

## Support

### Getting Help

- **Documentation**: Check this README and INSTALLATION.md
- **WordPress Admin**: Use the connection test in Settings
- **BrightTally Support**: Visit [brighttally.com/support](https://brighttally.com/support)
- **Email**: Contact support through your BrightTally account

### Debugging

Enable WordPress debugging to see detailed error messages:

1. Edit `wp-config.php`
2. Add: `define('WP_DEBUG', true);`
3. Check `/wp-content/debug.log` for errors

### Browser Console

Check browser console (F12) for JavaScript errors:
- Open Developer Tools
- Go to Console tab
- Look for errors related to BrightTally

## Changelog

### Version 1.0.0

**Initial Release**

- ✅ OAuth authentication with BrightTally
- ✅ Account creation from WordPress
- ✅ Shortcode support with full customization
- ✅ Gutenberg block with visual poll picker
- ✅ Admin dashboard with poll management
- ✅ Onboarding wizard for new users
- ✅ Real-time poll results
- ✅ Light and dark themes
- ✅ Responsive design
- ✅ API integration
- ✅ Token management
- ✅ Error handling and validation

## License

GPLv2 or later - https://www.gnu.org/licenses/gpl-2.0.html

## Credits

Developed by BrightTally - [brighttally.com](https://brighttally.com)

