# BrightTally WordPress Plugin Installation Guide

## Prerequisites

- WordPress 5.0 or higher
- PHP 7.4 or higher
- A BrightTally account (sign up at [brighttally.com](https://brighttally.com))

## Installation

### Method 1: Manual Installation

1. Download the plugin files
2. Upload the `bright-tally` folder to `/wp-content/plugins/` directory
3. Activate the plugin through the 'Plugins' menu in WordPress

### Method 2: WordPress Admin Upload

1. Go to Plugins > Add New in your WordPress admin
2. Click "Upload Plugin"
3. Choose the plugin zip file
4. Click "Install Now"
5. Activate the plugin

## Configuration

### OAuth Connection (Recommended)

1. Go to **BrightTally** in your WordPress admin menu
2. Click on **Settings**
3. Click **"Sign In to BrightTally"** or **"Create New Account"**
4. Follow the OAuth flow to connect your account
5. Your account will be automatically connected

### Manual API Token Setup (Advanced - Pro/Agency/Enterprise Only)

**Note:** OAuth connection is recommended and works for all plans. API tokens are only available for Pro, Agency, and Enterprise plans.

1. Go to **BrightTally > Settings**
2. Click **"Enter API Token"**
3. Get your API token from BrightTally (requires Pro plan or higher):
   - Log in to [brighttally.com](https://brighttally.com)
   - Click your profile menu (top right)
   - If you have a Pro, Agency, or Enterprise plan, you'll see **API Tokens**
   - Create a new token and copy it
4. Paste the token in WordPress
5. Set your preferred default theme and cache duration
6. Click **Save Changes**
7. Test the connection to ensure everything is working

**Don't see API Tokens?** You're on the Free plan. Use OAuth connection instead (above) - it's easier and works great!

## Usage

### Basic Shortcode

```
[bright_tally id="your-poll-id"]
```

### Advanced Shortcode with Options

```
[bright_tally id="your-poll-id" theme="dark" width="100%" show_results="true" allow_voting="true"]
```

### Available Attributes

- `id` - The poll ID (required)
- `theme` - Poll theme: "light" or "dark" (default: "light")
- `width` - Poll width: "100%", "500px", etc. (default: "100%")
- `height` - Poll height: "auto", "300px", etc. (default: "auto")
- `show_results` - Show results: "true" or "false" (default: "false")
- `allow_voting` - Allow voting: "true" or "false" (default: "true")

## Creating Polls

1. Go to [brighttally.com](https://brighttally.com) and sign in
2. Create a new poll in your dashboard
3. Copy the poll ID
4. Use the shortcode in your WordPress posts or pages

## Managing Polls

- View all your polls in **BrightTally > Polls** in WordPress admin
- Get shortcodes for existing polls
- Test poll functionality
- View poll statistics

## Troubleshooting

### Plugin Not Working
- Verify your account is connected (OAuth or API token)
- Check that your API token is correct (if using manual setup)
- Verify the API URL is set correctly
- Test the connection in settings
- Try reconnecting via OAuth (recommended)

### Polls Not Displaying
- Ensure the poll ID is correct
- Check that the poll is active in your BrightTally account
- Verify the shortcode syntax

### Styling Issues
- Check if your theme is conflicting with plugin styles
- Try different theme options (light/dark)
- Adjust width and height attributes

## Support

For additional help:
- Check the plugin documentation
- Contact support at [brighttally.com/support](https://brighttally.com/support)
- Visit the plugin settings for connection testing

## Changelog

### Version 1.0.0
- Initial release
- Basic poll embedding functionality
- Admin dashboard
- Shortcode support
- API integration
- Responsive design
