# BrightTally WordPress Plugin - Documentation Links

## Quick Access

All documentation is available online at **https://brighttally.com/docs/wordpress**

## Documentation Sections

### Getting Started
- **Installation**: https://brighttally.com/docs/wordpress/setup/downloading-the-wordpress-plugin
- **Connection Setup**: https://brighttally.com/docs/wordpress/setup/connecting-the-wordpress-plugin
- **Quick Start Guide**: https://brighttally.com/docs/wordpress/setup

### Using the Plugin
- **Embedding Polls**: https://brighttally.com/docs/wordpress/manage/embedding-polls-and-forms
- **Shortcode Reference**: https://brighttally.com/docs/wordpress/manage/embedding-polls-and-forms#shortcodes
- **Gutenberg Block**: https://brighttally.com/docs/wordpress/manage/embedding-polls-and-forms#gutenberg-block

### Troubleshooting
- **OAuth Issues**: https://brighttally.com/docs/wordpress/troubleshooting/oauth-errors
- **Connection Problems**: https://brighttally.com/docs/wordpress/troubleshooting
- **Common Issues**: https://brighttally.com/docs/wordpress/troubleshooting

### Account & Plans
- **Subscription Plans**: https://brighttally.com/docs/account/permissions/plan-access
- **Account Management**: https://brighttally.com/docs/account

## Accessing Documentation in WordPress

### Method 1: Documentation Menu
1. Go to **BrightTally > Documentation** in WordPress admin
2. Browse documentation sections
3. Click any link to open in new tab

### Method 2: Help Panel
1. Go to **BrightTally > Dashboard**
2. Click **"Show Help"** button
3. Browse quick links or search documentation

### Method 3: Settings Page
1. Go to **BrightTally > Settings**
2. Click **"View Documentation"** or **"Connection Help"** buttons
3. Links open in new tab

### Method 4: Polls Page
1. Go to **BrightTally > Polls**
2. Click **"Embedding Guide"** or **"Full Documentation"** buttons
3. Access relevant guides

## Support

If you can't find what you need in the documentation:

- **Email Support**: hello@brighttally.com
- **Support Portal**: https://brighttally.com/support
- **In-App Support**: Use the messenger in your BrightTally dashboard

## Local Documentation Files

The plugin includes these documentation files:

- `README.md` - Complete plugin documentation
- `USER_GUIDE.md` - User guide with examples
- `INSTALLATION.md` - Installation instructions
- `DOCUMENTATION.md` - This file (documentation links)

These files are included in the plugin package for offline reference.

